function targeter(current, type, infoStyle)
{
	this.current = current;
	this.type = type;
	this.all = false;
	this.selection = 0;
	switch (current)
	{
		case "Ally":
			this.side = system.currentBattle.party;
			break;
		case "Enemy":
			this.side = system.currentBattle.enemy;
			break;
	}
	if (type == "Multiple" || type == "Multiple-Only")
	{
		this.all = true;
		this.cloneSide();
	}
	else
		this.target = new Array(this.side[0]);
	this.done = false;
	this.infoStyle = infoStyle;
	this.oldStyle = "";
}

targeter.prototype.draw = function()
{
	var coordinates = new Array();
	if (this.target.length == 1)
	{
		coordinates = this.target[0].sprite.getCoordinates(this.target[0].x, this.target[0].y, true);
		drawCursor(coordinates[0], coordinates[1]);
	}
	else
	{
		for (var i = 0; i < this.target.length; i ++)
		{
			drawCursor(this.target[i].x, this.target[i].y, true);
		}
	}
}

targeter.prototype.control = function()
{
	if (this.infoStyle != undefined && this.infoStyle != system.currentBattle.infoStyle)
	{
		this.oldStyle = system.currentBattle.infoStyle;
		system.currentBattle.infoStyle = this.infoStyle;
	}
	if (IsPress())
	{
		if (IsKeyPressed(KEY_UP))
		{
			if (!this.all)
			{
				Press();
				if (this.selection == 0)
				{
					this.selection == this.side.length - 1;
				}
				else
					this.selection --;
				this.target = new Array(this.side[this.selection]);
			}
		}
		else if (IsKeyPressed(KEY_DOWN))
		{
			if (!this.all)
			{
				Press();
				if (this.selection == this.side.length - 1)
				{
					this.selection = 0;
				}
				else
					this.selection ++;
				this.target = new Array(this.side[this.selection]);
			}
		}
		else if (IsKeyPressed(KEY_LEFT))
		{
			Press();
			if (this.current == "Ally")
			{
				this.current = "Enemy";
				this.selection = 0;
				this.side = system.currentBattle.enemy;
				if (this.all)
				{
					this.cloneSide();
				}
				else
					this.target = new Array(this.side[this.selection]);
			}
		}
		else if (IsKeyPressed(KEY_RIGHT))
		{
			Press();
			if (this.current == "Enemy")
			{
				this.current = "Ally";
				this.selection = 0;
				this.side = system.currentBattle.party;
				if (this.all)
				{
					this.cloneSide();
				}
				else
					this.target = new Array(this.side[this.selection]);
			}
		}
		if (IsKeyPressed(KEY_A) && IsKeyPressed(KEY_SHIFT))
		{
			if (this.type != "Single-Only" && this.type != "Multiple-Only")
			{
				Press();
				if (!this.all)
				{
					//log.write("Select all");
					this.all = true;
					this.cloneSide();
				}
				else
				{
					//log.write("Select one");
					this.all = false;
					this.target = new Array(this.side[this.selection]);
				}
			}
		}
		if (IsKeyPressed(system.accept) && !IsKeyPressed(KEY_SHIFT))
		{
			log.write("Targeting done");
			this.done = this.target;
		}
		else if (IsKeyPressed(system.cancel) && !IsKeyPressed(KEY_SHIFT))
		{
			this.done = true;
		}
	}
	if (this.done != false)
	{
		if (typeof this.done != "object")
		{
			return true;
		}
		else
		{
			if (this.oldStyle != "" && this.infoStyle != undefined)
			{
				system.currentBattle.infoStyle = this.oldStyle;
				this.oldStyle = "";
			}
			return this.target;
		}
	}
	else
		return undefined;
}

targeter.prototype.cloneSide = function()
{
	this.target = new Array(this.side.length);
	for (var i = 0; i < this.side.length; i ++)
	{
		this.target[i] = this.side[i];
	}
}